// Turret.js //

RequireScript("Pulses.js");
RequireScript("Bullets.js");

const GUNNER = 0;
const LASER = 1;
const PULSER = 2;
const SNIPER = 3;
const ROCKET = 4;

var Turrets = [];
var TurretSS = LoadSpriteset("Turrets.rss");
var TurretTopSS = LoadSpriteset("TurretTops.rss");

function Turret(x, y)
{
	var turret = Cursor.turretItem;
	this.x = x;
	this.y = y;
	this.a = 0;
	this.type = turret.type;
	this.img = turret.img;
	this.top = TurretTopSS.images[this.img];
	this.bottom = TurretSS.images[this.img];
	this.level = 0;
	this.range = turret.range;
	this.timer = GetTime();
	this.rate = turret.rate;
	this.atk = turret.atk;
	this.price = turret.price;
	this.cost = turret.cost;
	this.active = true;
	this.target = null;
	this.color = Colors.white;
	this.kills = 0;
}

Turret.prototype.blit = function()
{
	var x = MapToScreenX(0, this.x-7);
	var y = MapToScreenY(0, this.y-7);
	this.bottom.blit(x, y);
	this.top.rotateBlitMask(x-9, y-9, this.a, this.color);
}

Turret.prototype.update = function()
{
	if (!this.active) return;
	
	if (this.type != PULSER)
	{
		if (!this.target) this.target = GetClosestEnemy(this.x, this.y, this.range);
		if (!this.target) return;
		if (this.target.dead) { this.target = null; return; }

		var ex = this.target.x+8;
		var ey = this.target.y+8;
		this.a = Math.atan2(ey-this.y, ex-this.x);
	}
	
	if (this.timer + this.rate < GetTime()) {
		if (this.type == PULSER) {
			CreatePulse(this);
			this.timer = GetTime();
		}
		else {
			if (GetDist(ex-this.x, ey-this.y) > this.range) { this.target = null; return; }
			CreateBullet(this);
			this.timer = GetTime();
		}
	}
}

function PlaceTurret(x, y)
{
	var x = Math.floor(x/16)*16+7;
	var y = Math.floor(y/16)*16+7;
	Turrets.push(new Turret(x, y));
}

function GetTurretAt(x, y, exclude)
{
	var i = Turrets.length;
	while(i--) {
		var turret = Turrets[i];
		if (exclude) { if (Turrets[i] == Cursor.turret) continue; }
		if ((turret.x >> 4) == x>>4 && (turret.y >> 4) == y>>4) return turret;
	}
	return null;
}

function Upgrade()
{
	var turret = Cursor.turret;
	if (Game.money >= turret.cost) Game.money -= turret.cost;
	else return;
	switch(turret.type) {
		case GUNNER:
			turret.atk += 3;
			turret.rate -= 50;
		break;
		case LASER:
			turret.atk += 2;
			turret.rate -= 10;
		break;
		case PULSER:
			turret.atk += 2;
			turret.rate -= 40;
			turret.range -= 2;
		break;
		case SNIPER:
			turret.atk += 10;
			turret.range += 2;
			turret.rate -= 400;
		break;
		case ROCKET:
			turret.atk += 5;
			turret.rate -= 200;
			turret.range += 1;
		break;
	}
	turret.level++;
	if (turret.level == 1) turret.color = Colors.green;
	if (turret.level == 2) turret.color = Colors.blue;
	if (turret.level == 3) turret.color = Colors.red;
	turret.range += 4;
	turret.price += turret.cost;
	turret.cost *= 2;
	Game.showDropMenu = false;
}

function Sell()
{
	var turret = Cursor.turret;
	Game.money += turret.price;
	Cursor.turret = null;
	Turrets.splice(Turrets.indexOf(turret), 1);
	Game.showDropMenu = false;
}

function MoveTurret()
{
	var turret = Cursor.turret;
	turret.active = false;
	Cursor.move = true;
	Game.showDropMenu = false;
}

function UpdateTurrets()
{
	var i = Turrets.length;
	while(i--) { Turrets[i].update(); }
}

function DrawTurrets()
{
	var i = Turrets.length;
	while(i--) { Turrets[i].blit(); }
}

function GetDist(x, y) {
	return Math.sqrt(x * x + y * y);
}

// Check closest distance...
function GetClosestEnemy(x, y, rad, amt)
{
	var enemies = [];
	var distances = [];
	var i = Enemies.length;
	while(i--) {
		var enemy = Enemies[i];
		var dist = GetDist(x - (enemy.x + 8), y - (enemy.y + 8));
		if (rad && dist > rad) continue;
		if (!amt) return enemy;
		else distances.push({enemy: enemy, dist: dist});
	}
	distances.sort(s2l);
	
	if (distances.length == 0) return null;
	else if (amt) 
	{
		for (var i = 0; i < amt; ++i) {
			if (i == distances.length) break;
			enemies.push(distances[i].enemy);
		}
		return enemies;
	}
	else return distances[0].enemy;
}

// Magical faries do this:
function s2l(a, b)
{
	return a.dist - b.dist;
}

// For menu/placement/stat data //
function TurretItem(name, price, atk, range, rate, img, cost, type)
{
	this.name = name;
	this.range = range;
	this.rate = rate;
	this.atk = atk;
	this.price = price;
	this.cost = cost;
	this.img = img;
	this.type = type;
	this.image = TurretSS.images[img].createSurface();
	this.image.blitSurface(TurretTopSS.images[img].createSurface(), -8, -8);
	this.image = this.image.createImage(); 
}

TurretItems = [];
TurretItems[0] = new TurretItem("Gunner", 10, 5, 40, 450, 0, 8, GUNNER);
TurretItems[1] = new TurretItem("Pulser", 14, 4, 32, 500, 2, 12, PULSER);
TurretItems[2] = new TurretItem("Laser", 20, 2, 32, 100, 1, 10, LASER);
TurretItems[3] = new TurretItem("Sniper", 26, 40, 80, 2400, 3, 13, SNIPER);
TurretItems[4] = new TurretItem("Rocketeer", 30, 25, 40, 1200, 4, 15, ROCKET);